﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.VistaPharmacyModels;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System.Diagnostics;
using Microsoft.Xrm.Sdk.Messages;

namespace PpmsDataWebService.Mappers
{
    public class VistaPharmacyProviderIdentifiersMap
    {
        public static async Task<IQueryable<VistaPharmacyProviderIdentifier>> MapVistaPharmacyProviderIdentifiers(List<ppms_provideridentifier> ppmsProviderIdentifiers,string queryType, IOrganizationService _service)
        {
            var providerIdentifiersList = new List<VistaPharmacyProviderIdentifier> { };       
            int count = 0;
            
            foreach (var ppmsProviderIdentifier in ppmsProviderIdentifiers)
            {
                count += 1;                         
                var providerIdentifier = new VistaPharmacyProviderIdentifier
                {
                    ProviderIdentifier = ppmsProviderIdentifier.ppms_ProviderIdentifier
                };

                //Provider Identifier Type
                if (ppmsProviderIdentifier.ppms_IdentifierType != null)
                    switch (ppmsProviderIdentifier.ppms_IdentifierType.Value)
                    {
                        case (int)ppms_provideridentifier_ppms_IdentifierType.NPI:
                            providerIdentifier.ProviderIdentifierType = ProviderIdentifierType.Npi;
                            break;
                        case (int)ppms_provideridentifier_ppms_IdentifierType.TaxIDNumber:
                            providerIdentifier.ProviderIdentifierType = ProviderIdentifierType.TaxIdentificationNumber;
                            break;
                    }

                //Primary Provider NPI
                if (ppmsProviderIdentifier.Attributes.ContainsKey("provider.ppms_provideridentifier") == true)
                {
                    providerIdentifier.PrimaryProviderNPI = (string)ppmsProviderIdentifier.GetAttributeValue<AliasedValue>("provider.ppms_provideridentifier").Value;
                }

                //Status
                if (ppmsProviderIdentifier.StatusCode != null)
                    switch (ppmsProviderIdentifier.StatusCode.Value)
                    {
                        case (int)ppms_provideridentifier_StatusCode.Active:
                            providerIdentifier.StatusReason = ProviderIdentifierStatusReason.Active;
                            break;
                        case (int)ppms_provideridentifier_StatusCode.Inactive:
                            providerIdentifier.StatusReason = ProviderIdentifierStatusReason.Inactive;
                            break;
                    }

                providerIdentifiersList.Add(providerIdentifier);              
            }          
            var provIdentifiers = providerIdentifiersList.AsQueryable();
            return provIdentifiers;
        }
    }
}